function X=Trace_3axes_trajectoire(q,p,specs)
%trac trajectoire relle du robot  partir de q=3*n chantillons
%trac trajectoire attendue du robot  partir de p=2 positions
figure
hold on
grid on
plot3(p(1,1:2),p(2,1:2),p(3,1:2),'ok','LineWidth',3);
n=numel(q(1,:));

l1=0.0935;
l2=0.1075;
w=[];
%remapping
for i=1:n
q1=q(1,i);
q2=q(2,i);
q3=q(3,i);

T01=[cos(q1) -sin(q1) 0 0;sin(q1) cos(q1) 0 0;0 0 1 0; 0 0 0 1];
T12=[cos(q2) 0 sin(q2) 0;0 1 0 0;-sin(q2) 0 cos(q2) 0; 0 0 0 1 ];
T23=[cos(q3) 0 sin(q3) 0;0 1 0 0;-sin(q3) 0 cos(q3) l1; 0 0 0 1 ];
P3=[0 0 l2 1]';

T=T01*T12*T23;

Xp=T*(P3+[0 0 0.01 1]');
Xpp=(T*P3)';
X=[0 0 0
   T(1:3,4)' 
   Xpp(1:3)];
w=[w;X(3,:)];
hold off
plot3(X(1:3,1),X(1:3,2),X(1:3,3),'LineWidth',3);
hold on
grid on
plot3(X(1:3,1),X(1:3,2),X(1:3,3),'or','LineWidth',3);
plot3(p(1,1:2),p(2,1:2),p(3,1:2),'ok','LineWidth',3);
plot3(w(:,1),w(:,2),w(:,3),'--g','LineWidth',3);
        axis([-0.25 0.25 -0.25 0.25 -0.25 0.25])
        %set(gca,'DataAspectRatio',[1 1 1]);
        view(45,45);
        pause(0.1);
end
end